unit ServerForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DdeMan, Shell_DDE;

type
(***************************************************************************************
  Object TForm1

  Comments: To demonstrate the TShellCommandInterface component

  Version:  1.00
  Date last Modified: 28 May 2000
****************************************************************************************)

  TForm1 = class(TForm)
    Memo1: TMemo;
    ShellCommandInterface: TShellCommandInterface;
    lblInstructions: TLabel;
    LblRegister: TLabel;
    lblUnRegister: TLabel;
    lblTestFile: TLabel;
    Label1: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure ShellCommandInterfaceCustomDefaultCommand(Command, FileName,
      Option: String);
    procedure ShellCommandInterfaceOpenFile(FileName, Option: String);
    procedure FormResize(Sender: TObject);
    procedure ShellCommandInterfaceCommandSwitch(Switch: String);
  private
    { Private declarations }
    Function  IsBusy: Boolean;
  public
    { Public declarations }
  end;
var
  Form1: TForm1;

{---------------------------------------------------------------------------------------

---------------------------------------------------------------------------------------}

implementation

{---------------------------------------------------------------------------------------

---------------------------------------------------------------------------------------}

{$R *.DFM}

(***************************************************************************************
  Object:   TForm1
  Function: IsBusy

  Comments: Always returns false - but your program may need to determine whether it
            can deal with the command or needs to start another session or allow user
            to cancel

  Version:  1.00
  Date last Modified: 28 May 2000
****************************************************************************************)

Function  TForm1.IsBusy: Boolean;

Begin
  Result:= False;
End;


(***************************************************************************************
  Object:      TForm1
  Constructor: Create

  Comments:    Set up the instructions at the top of the form

  Version:   1.00
  Date last Modified: 28 May 2000
****************************************************************************************)

procedure TForm1.FormCreate(Sender: TObject);

Begin
  LblRegister.Caption:= ParamStr(0) + ' /register';
  lblUnRegister.Caption:= ParamStr(0) + ' /unregister';
  lblTestFile.Caption:= ExtractFilePath(ParamStr(0)) + 'Test.Test';
end;

(***************************************************************************************
  Object:   TForm1
  Function: ShellCommandInterfaceCustomDefaultCommand

  Comments: This is the event triggered when a "Custom Command" is recieved.
            If the standard commands are recieved but have no assigned event
            then this event will be triggered

  Version:  1.00
  Date last Modified: 28 May 2000
****************************************************************************************)

procedure TForm1.ShellCommandInterfaceCustomDefaultCommand(Command,
  FileName, Option: String);

begin
  If IsBusy Then Begin
    // Put functionality (if required) to handle when busy.
  End
  Else Begin
    // Display time, command, filename and options passed
    With Memo1.Lines Do Begin
      Add('*************');
      Add(FormatDateTime('hh:nn:ss', Now));
      Add('Command - ' + Command);
      Add('Filename - ' + Filename);
      Add('Options - ' + Option);
    End;
  End;
end;

(***************************************************************************************
  Object:   TForm1
  Function: ShellCommandInterfaceOpenFile

  Comments: This is the event triggered when the user selects Open or double clicks
            on a file in explorer.  If this event is deleted then the actions will go
            to ShellCommandInterfaceCustomDefaultCommand

  Version:  1.00
  Date last Modified: 28 May 2000
****************************************************************************************)

procedure TForm1.ShellCommandInterfaceOpenFile(FileName, Option: String);
begin
  If IsBusy Then Begin
    // Put functionality (if required) to handle when busy.
  End
  Else Begin
    // Display time, command, filename and options passed
    With Memo1.Lines Do Begin
      Add('*************');
      Add(FormatDateTime('hh:nn:ss', Now));
      Add('Open File');
      Add('Filename - ' + Filename);
      Add('Options - ' + Option);
    End;
  End;
end;

(***************************************************************************************
  Object:   TForm1
  Function: ShellCommandInterfaceCommandSwitch

  Comments: This event is triggered for every command line switch -e.g. '/register'
            or '-unregister'

  Version:  1.00
  Date last Modified: 28 May 2000
****************************************************************************************)

procedure TForm1.ShellCommandInterfaceCommandSwitch(Switch: String);

Begin
  // register the file association details
  If Lowercase(switch) = 'register'  Then Begin
    ShellCommandInterface.RegisterFileAssociations(False);
    MessageBoxA(Handle, 'File Ext Registered', 'Register', MB_ICONINFORMATION);
  End;
  // unregister the file association details
  If Lowercase(switch) = 'unregister' Then Begin
    ShellCommandInterface.UnRegisterFileAssociations;
    MessageBoxA(Handle, 'File Ext Unregistered', 'Register', MB_ICONINFORMATION);
  End;
end;

(***************************************************************************************
  Object:   TForm1
  Function: FormResize

  Comments: When the form is resize change the memo height as appropriate

  Version:  1.00
  Date last Modified: 28 May 2000
****************************************************************************************)

procedure TForm1.FormResize(Sender: TObject);
begin
  Memo1.Height:= ClientHeight  -  100;
end;


end.
